﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Controls.Custom.BPR
{
    public partial class controls_UserControlCheckBoxPreview : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
        }

        public string CheckBoxValue
        {
            set
            {
                CheckBoxControl.Text = Helpers.AntiXssEval(value);
            }
        }

        public string HelpText
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    LabelHelp.Visible = true;
                    LabelHelp.Text = Helpers.AntiXssEval(value);
                }
                else
                {
                    LabelHelp.Visible = false;
                }
            }
        }

        public bool CheckBoxEditable
        {
            set
            {
                if (value)
                {
                    TextBoxControl.Visible = true;
                }
                else
                {
                    TextBoxControl.Visible = false;
                    LabelForTextBoxControl.Visible = false;
                }
            }
        }
    }
}